var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, element:null, timer:null};
var flipShown = false;


function limit_3(a, b, c)
{
	return a < b ? b : (a > c ? c : a);
}
function computeNextFloat (from, to, ease)
{
	return from + (to - from) * ease;
}


function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
	
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}

	animation.element.style.opacity = animation.now;
}

function mousemove(event)
{
	if(!flipShown)
	{
		if(animation.timer != null)
		{
			clearInterval(animation.timer);
			animation.timer = null;
		}
		
		var startTime = (new Date).getTime() - 13;
		
		animation.duration = 500;
		animation.starttime = startTime;
		animation.element = document.getElementById('flippyimg');
		animation.timer = setInterval("animate();", 13);
		animation.from = animation.now;
		animation.to = 1.0;
		animate();
		
		flipShown = true;
	}
}


function mouseexit(event)
{
	if(flipShown)
	{
		if(animation.timer != null)
		{
			clearInterval(animation.timer);
			animation.timer = null;
		}
		
		var starttime = (new Date).getTime() - 13;
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.element = document.getElementById('flippyimg');
		animation.timer = setInterval("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}


function enterflip(event)
{
	document.getElementById('flipcircle').style.display = 'block';
}


function exitflip(event)
{
	document.getElementById('flipcircle').style.display = 'none';
}


function getTimeDiff(event)
{
	theTimeDiff = document.getElementById('timediff').value;
	widget.setPreferenceForKey(theTimeDiff, "timeDiff");
}


function getTimeDiffValue()
{
	var theTimeDiff = widget.preferenceForKey("timeDiff");

	if(theTimeDiff && theTimeDiff.length > 0)
	{
	}
	else
	{
		theTimeDiff = "0";
	}
	
	return theTimeDiff;
}


function drawTimeDiffMenu()
{
	var				i = 0;
	var				theTimeDiff = widget.preferenceForKey("timeDiff");

	if(theTimeDiff && theTimeDiff.length > 0)
	{
	}
	else
	{
		theTimeDiff = "0";
	}

	document.writeln('<select style="z-index:80;" name="timediff" onclick="getTimeDiff(event);" id="timediff">');
	for(i = -4; i < 21; i++)
	{
		document.write('<option value="'+i+'"');
		if(theTimeDiff == i)
			document.write(" selected");
		document.writeln(">"+i);
	}
	document.writeln('</select>');
}


function GotoEdit()
{
	var front = document.getElementById('front');
	var back = document.getElementById('back');
	
	if(window.widget)
		widget.prepareForTransition("ToBack");
	
	front.style.display = 'none';
	back.style.display  = 'block';

	setTimeout("widget.performTransition();", 0);
}


function ReturnFromEdit()
{
	var front = document.getElementById('front');
	var back = document.getElementById('back');
	
	if(widget)
		widget.prepareForTransition("ToFront");
	
	front.style.display = 'block';
	back.style.display  = 'none';

	setTimeout("widget.performTransition();", 0);
}